// Study page JavaScript
document.addEventListener('DOMContentLoaded', function() {
    console.log('AED Study page loaded successfully');
    
    // Make image 8 (cable) draggable
    const draggableElement = document.getElementById('draggable-cable');
    const targetElement = document.querySelector('.chest-highlight'); // Rectangle 2
    
    if (draggableElement && targetElement) {
        let isDragging = false;
        let currentX;
        let currentY;
        let initialX;
        let initialY;
        let xOffset = 0;
        let yOffset = 0;
        
        draggableElement.addEventListener('mousedown', dragStart);
        document.addEventListener('mousemove', drag);
        document.addEventListener('mouseup', dragEnd);
        
        // Touch support for mobile
        draggableElement.addEventListener('touchstart', dragStart);
        document.addEventListener('touchmove', drag);
        document.addEventListener('touchend', dragEnd);
        
        function dragStart(e) {
            if (e.type === 'touchstart') {
                initialX = e.touches[0].clientX - xOffset;
                initialY = e.touches[0].clientY - yOffset;
            } else {
                initialX = e.clientX - xOffset;
                initialY = e.clientY - yOffset;
            }
            
            if (e.target === draggableElement || draggableElement.contains(e.target)) {
                isDragging = true;
                draggableElement.classList.add('dragging');
            }
        }
        
        function drag(e) {
            if (isDragging) {
                e.preventDefault();
                
                if (e.type === 'touchmove') {
                    currentX = e.touches[0].clientX - initialX;
                    currentY = e.touches[0].clientY - initialY;
                } else {
                    currentX = e.clientX - initialX;
                    currentY = e.clientY - initialY;
                }
                
                xOffset = currentX;
                yOffset = currentY;
                
                setTranslate(currentX, currentY, draggableElement);
                
                // Check for collision while dragging
                checkCollision();
            }
        }
        
        function dragEnd(e) {
            if (isDragging) {
                initialX = currentX;
                initialY = currentY;
                isDragging = false;
                draggableElement.classList.remove('dragging');
                
                // Final collision check
                checkCollision();
            }
        }
        
        function setTranslate(xPos, yPos, el) {
            el.style.transform = `translate(${xPos}px, ${yPos}px)`;
        }
        
        function checkCollision() {
            const rect1 = draggableElement.getBoundingClientRect();
            const rect2 = targetElement.getBoundingClientRect();
            
            // Check if rectangles overlap
            const isColliding = !(
                rect1.right < rect2.left ||
                rect1.left > rect2.right ||
                rect1.bottom < rect2.top ||
                rect1.top > rect2.bottom
            );
            
            if (isColliding) {
                console.log('Collision detected! Navigating to next page...');
                // Add a small delay for visual feedback
                setTimeout(() => {
                    window.location.href = 'step1-complete.html';
                }, 300);
            }
        }
    }
});
